/*
	esoview

	mk@lemo.dk, 7-nov-2012

	Inspired by NeHe code by Jeff Molofee

	Don't even think of running this code on a 32 bit machine...
*/


#include <GL/glut.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <math.h>
#include <assert.h>
#include "../include/smi.h"

/* The number of our GLUT window */
int window; 
int window_width, window_height;
int fullscreen=0;
GLfloat window_aspect;

GLuint loop;             // general loop variable
GLuint textures[9];       // storage for 3x3 textures;
char *texturesdata[9];	// last pointer

int xmin, xmax, ymin, ymax;

GLfloat LightAmbient[]  = {0.5f, 0.5f, 0.5f, 1.0f}; 
GLfloat LightDiffuse[]  = {1.0f, 1.0f, 1.0f, 1.0f}; 
GLfloat LightPosition[] = {0.0f, 0.0f, 2.0f, 1.0f};

// Input file, generated by split
int in_fd;
long filesize;
long imagex, imagey;
char *in_data;
struct SMIFILE *smifile;
int nlevels;
int currentlevel=3;
char *blacktexture;

struct TEXTURELEVELS
{
  char *data;
  long nx,ny;
  long imagex, imagey;
} *texturelevels;

/* Transformation information */

int xmina, xmaxa, ymina, ymaxa;
int motionx, motiony, inmotion=0;
int motiondx, motiondy;

void Screen2Pixel(int screenx, int screeny, int *x, int *y)
{
  *x = ((GLfloat) screenx)/((GLfloat) window_width)*(xmaxa-xmina)+xmina;
  *y = ((GLfloat) screeny)/((GLfloat) window_height)*(ymaxa-ymina)+ymina;
}


void SetFullDisplay()
{
  xmin = 0;
  ymin = 0;
  xmax = texturelevels[0].imagex-1;
  ymax = texturelevels[0].imagey-1;
}

// Set up texture levels
GLvoid SetUpTextureLevels(char *filename)
{
  long offset,imagex,imagey,nx,ny,imagex2,imagey2,nx2,ny2;
  int i,j;

  in_fd = open(filename, O_RDONLY);
  assert(in_fd >= 0);

  smifile = (struct SMIFILE *) mmap(NULL, SMI_HEADER_SIZE, PROT_READ, MAP_SHARED, in_fd, 0);
  assert(smifile != NULL);
  assert(smifile->smi_magic == SMI_MAGIC);

  offset = SMI_HEADER_SIZE;
  imagex = smifile->width;
  imagey = smifile->height;
  nx = (smifile->width + SMIX - 1)/SMIX;
  ny = (smifile->height + SMIY - 1)/SMIY;
  nlevels = 1;
  while(nx>1 || ny>1)
  {
    imagex2 = imagex/2;
    imagey2 = imagey/2;
    nx2 = (imagex2+SMIX-1)/SMIX;
    ny2 = (imagey2+SMIY-1)/SMIY;
    offset += nx*ny*SMIX*SMIY*3;
    nlevels++;
    imagex = imagex2;
    imagey = imagey2;
    nx = nx2;
    ny = ny2;
    // printf("offset: %ld\n", offset);
  }
  filesize = offset + SMIX*SMIY*3;
  // printf("filesize: %ld\n", filesize);
  in_data = (char *) mmap(NULL, filesize, PROT_READ, MAP_SHARED, in_fd, 0);
  assert(in_data != NULL);

  texturelevels = (struct TEXTURELEVELS *) malloc(sizeof(*texturelevels)*nlevels);

  nlevels = 0;
  texturelevels[nlevels].data = in_data + SMI_HEADER_SIZE;
  texturelevels[nlevels].imagex = smifile->width;
  texturelevels[nlevels].imagey = smifile->height;
  texturelevels[nlevels].nx = (smifile->width + SMIX - 1)/SMIX;
  texturelevels[nlevels].ny = (smifile->height + SMIY - 1)/SMIY;
  nlevels++;
  while(texturelevels[nlevels-1].nx>1 || texturelevels[nlevels-1].ny>1)
  {
    texturelevels[nlevels].data = texturelevels[nlevels-1].data + texturelevels[nlevels-1].nx*texturelevels[nlevels-1].ny*SMIX*SMIY*3;
    texturelevels[nlevels].imagex = texturelevels[nlevels-1].imagex/2;
    texturelevels[nlevels].imagey = texturelevels[nlevels-1].imagey/2;
    texturelevels[nlevels].nx = (texturelevels[nlevels].imagex+SMIX-1)/SMIX;
    texturelevels[nlevels].ny = (texturelevels[nlevels].imagey+SMIY-1)/SMIY;
    nlevels++;
  }
  printf("level\timagex\timagey\tnx\tny\toffset\n");
  for(i=0;i<nlevels;i++)
    printf("%d\t%d\t%d\t%d\t%d\t%ld\n",
	i,
	texturelevels[i].imagex,
	texturelevels[i].imagey,
	texturelevels[i].nx,
	texturelevels[i].ny,
	texturelevels[i].data-in_data);

  SetFullDisplay();
}

// Open big file of textures:
GLvoid LoadGLTextures()
{
  int i,j,ix,iy;
  glEnable(GL_TEXTURE_2D);
  glGenTextures(9, &textures[0]);

  /* Create black texture for border */
  blacktexture = (char *) malloc(SMIX*SMIY*3);
  assert(blacktexture != NULL);

  for(i=0; i<SMIY; i++)
    for(j=0; j<SMIX; j++)
    {
      blacktexture[(i*SMIX+j)*3+0] = 0;
      blacktexture[(i*SMIX+j)*3+1] = 0;
      blacktexture[(i*SMIX+j)*3+2] = 0;
    }

  for(i=0; i<9; i++)
  {
    ix = i%3;
    iy = i/3;
    glBindTexture(GL_TEXTURE_2D, textures[i]);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE ); 
    glTexImage2D(GL_TEXTURE_2D, 0, 3, SMIX, SMIY, 0, GL_RGB, GL_UNSIGNED_BYTE, blacktexture);
    texturesdata[i] = blacktexture;
  }
}

GLvoid InitGL(GLsizei Width, GLsizei Height)
{
  LoadGLTextures();

  // printf("InitGL: %d %d\n", Width, Height);

  window_width=Width;
  window_height=Height;
  window_aspect = ((GLfloat) Width)/((GLfloat) Height);

  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
  glShadeModel(GL_SMOOTH);
  
  glMatrixMode(GL_MODELVIEW);

  glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
  glLightfv(GL_LIGHT1, GL_POSITION, LightPosition);
  glEnable(GL_LIGHT1);
}

GLvoid ReSizeGLScene(GLsizei Width, GLsizei Height)
{
  if (Height==0) Height=1;
  // printf("ReSize: %d %d\n", Width, Height);
  window_width=Width;
  window_height=Height;
  window_aspect = ((double) Width)/((double) Height);

  glViewport(0, 0, Width, Height);

}

void SetInside()
{
  int width, height;

  width = xmax-xmin+1;
  height = ymax-ymin+1;
  if(width > texturelevels[0].imagex) width = texturelevels[0].imagex;
  if(height > texturelevels[0].imagey) height = texturelevels[0].imagey;

  if(xmin < 0)
  {
    xmin = 0;
    xmax = width-1;
  }
  if(xmax >= texturelevels[0].imagex)
  {
    xmax = texturelevels[0].imagex-1;
    xmin = xmax-width+1;
  }
  if(ymin < 0)
  {
    ymin = 0;
    ymax = height-1;
  }
  if(ymax >= texturelevels[0].imagey)
  {
    ymax = texturelevels[0].imagey-1;
    ymin = ymax-height+1;
  }
}

/* The main drawing function. */
GLvoid DrawGLScene(GLvoid)
{
  int width, height, texturedimension;
  int widthr, heightr;
  int ix, iy, ix2, iy2, xpos, ypos;
  char *ptexture;
GLfloat window_xmin, window_xmax, window_ymin, window_ymax;
  GLfloat xcenter, ycenter, aspect, xsize, ysize;

  /* Determine currentlevel: */

  width = xmax-xmin+1;
  height = ymax-ymin+1;
  aspect = ((GLfloat) width)/((GLfloat) height);
  /* Adjust for difference in aspect ratio */
  xmina = xmin;
  xmaxa = xmax;
  ymina = ymin;
  ymaxa = ymax;
  xcenter = (xmina+xmaxa)*0.5;
  ycenter = (ymina+ymaxa)*0.5;
  xsize = xmaxa-xmina;
  ysize = ymaxa-ymina;
  if(window_aspect > aspect)
  {
    xsize *= window_aspect/aspect;
    xmina = xcenter-xsize/2.0;
    xmaxa = xcenter+xsize/2.0;
  }
  else
  {
    ysize *= aspect/window_aspect;
    ymina = ycenter-ysize/2.0;
    ymaxa = ycenter+ysize/2.0;
  }

  widthr = xmaxa-xmina+1;
  heightr = ymaxa-ymina+1;
  motiondx = widthr;
  motiondy = heightr;
  currentlevel=0;
  while(widthr > SMIX*2 || heightr > SMIY*2)
  {
    currentlevel++;
    widthr /= 2;
    heightr /= 2;
  }
  // printf("window_aspect: %g aspect: %g\n", window_aspect, aspect);
  texturedimension = SMIX<<currentlevel;
  xpos = xmina/texturedimension;
  ypos = ymina/texturedimension;
  printf("xmin: %d xmax: %d ymin: %d ymax: %d width: %d height: %d xpos: %d ypos: %d level: %d\n", xmin, xmax, ymin, ymax, width, height, xpos, ypos, currentlevel);

  /*
     We map aver(xmin,xmax),aver(ymin,ymax) to center of screen, and scales
     so that xmin, xmax, ymin, and ymax are all visible:
  */

  window_xmin=(xmina-xpos*texturedimension)>>currentlevel;
  window_xmax=(xmaxa-xpos*texturedimension)>>currentlevel;
  window_ymin=(ymina-ypos*texturedimension)>>currentlevel;
  window_ymax=(ymaxa-ypos*texturedimension)>>currentlevel;

  // printf("window_xmin: %g window_xmax: %g window_ymin: %g window_ymax: %g\n", window_xmin, window_xmax, window_ymax, window_ymin);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(window_xmin, window_xmax,
	  window_ymax, window_ymin,
	  -1.0f, 1.0f);
  glMatrixMode(GL_MODELVIEW);
  glClear(GL_COLOR_BUFFER_BIT);
  glLoadIdentity();

  for(loop=0; loop<9; loop++)
  {
    ix = loop%3;
    iy = loop/3;

    glBindTexture(GL_TEXTURE_2D, textures[loop]);
    ix2 = xpos+ix;
    iy2 = ypos+iy;
    // ToDo: Test if texture is outside visible area
    if(ix2 < 0 || ix2 >= texturelevels[currentlevel].nx ||
       iy2 < 0 || iy2 >= texturelevels[currentlevel].ny)
    {
      ptexture = blacktexture;
    }
    else
    {
      ptexture = texturelevels[currentlevel].data+(iy2*texturelevels[currentlevel].nx+ix2)*SMIX*SMIY*3;
    }
    if(ptexture != texturesdata[loop])
    {
      glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, SMIX, SMIY, GL_RGB, GL_UNSIGNED_BYTE, ptexture);
      texturesdata[loop] = ptexture;
    }
    glBegin(GL_QUADS);
      /* glNormal3f( 0.0f, 0.0f, 1.0f); */
      glTexCoord2f(0.0f, 0.0f);
      glVertex3f((ix  )*SMIX, (iy  )*SMIY, 0.5f);
      glTexCoord2f(0.0f, 1.0f);
      glVertex3f((ix  )*SMIX, (iy+1)*SMIY, 0.5f);
      glTexCoord2f(1.0f, 1.0f);
      glVertex3f((ix+1)*SMIX, (iy+1)*SMIY, 0.5f);
      glTexCoord2f(1.0f, 0.0f);
      glVertex3f((ix+1)*SMIX, (iy  )*SMIY, 0.5f);
    glEnd();     
  }

  glutSwapBuffers();

}

void keyPressed(unsigned char key, int x, int y) 
{

  switch (key)
  {    
    case '\e':
    case 'q':
    case 'Q':
      exit(1);                   	
      break;

    case 'f':
    case 'F':
      if(fullscreen)
      {
	glutReshapeWindow(640, 480);
	fullscreen=0;
      }
      else
      {
	glutFullScreen();
	fullscreen=1;
      }
	break;

    default:
      // printf ("Key %d pressed. No action there yet.\n", key);
      break;
  }	
}

void specialKeyPressed(int key, int x, int y) 
{
  int width, height;
  width=xmax-xmin+1;
  height=ymax-ymin+1;

  switch (key)
  {    
    case GLUT_KEY_PAGE_UP:
      width = width*5/4;
      height = height*5/4;
      xmin = (xmax+xmin)/2 - width/2;
      ymin = (ymax+ymin)/2 - height/2;
      xmax = xmin+width-1;
      ymax = ymin+height-1;
      break;
    case GLUT_KEY_PAGE_DOWN:
      width = width*4/5;
      height = height*4/5;
      // printf("width: %d height: %d\n", width, height);
      if(width > 5 && height > 5)
      {
	xmin = (xmax+xmin)/2 - width/2;
	ymin = (ymax+ymin)/2 - height/2;
	xmax = xmin+width-1;
	ymax = ymin+height-1;
      }
      break;
    case GLUT_KEY_UP:
      ymin -= height/4;
      ymax -= height/4;
      break;
    case GLUT_KEY_DOWN:
      ymin += height/4;
      ymax += height/4;
      break;
    case GLUT_KEY_LEFT:
      xmin -= width/4;
      xmax -= width/4;
      break;
    case GLUT_KEY_RIGHT:
      xmin += width/4;
      xmax += width/4;
      break;
    case GLUT_KEY_HOME:
      SetFullDisplay();
      break;

    default:
	// printf ("Special key %d pressed. No action there yet.\n", key);
	break;
  }	
  SetInside();
}

void mouseFunc(int button, int state, int x, int y)
{
  int width, height;
  int picturex, picturey;
  Screen2Pixel(x, y, &picturex, &picturey);
  width=xmax-xmin+1;
  height=ymax-ymin+1;
  // printf("mouseFunc. Button: %d State: %d X: %d Y: %d picturex: %d picturey: %d\n", button, state, x, y, picturex, picturey);
  if(button == 0 && state == 0)
  {
    motionx = x;
    motiony = y;
    inmotion = 1;
  }
  else if(button == 0 && state == 1)
  {
    inmotion = 0;
  }
  else if(button == 3 && state == 1)
  {
    /* Scale up round center */
    width = width*4/5;
    height = height*4/5;
    // printf("width: %d height: %d\n", width, height);
    if(width > 5 && height > 5)
    {
      xmin = (xmin+xmax)/2 - width/2;
      ymin = (ymin+ymax)/2 - height/2;
      xmax = xmin+width-1;
      ymax = ymin+height-1;
      SetInside();
    }
  }
  else if(button == 4 && state == 1)
  {
    /* Scale down round center */
    width = width*5/4;
    height = height*5/4;
    xmin = (xmin+xmax)/2 - width/2;
    ymin = (ymin+ymax)/2 - height/2;
    xmax = xmin+width-1;
    ymax = ymin+height-1;
    SetInside();
  }
}

void motionFunc(int x, int y)
{
  int dx, dy;
  // printf("motionFunc. X: %d Y: %d\n", x, y);

  if(inmotion)
  {
    dx = (x-motionx)*motiondx/window_width;
    dy = (y-motiony)*motiondy/window_height;
    // printf("inmotion: dx: %d dy: %d\n", dx, dy);
    xmin -= dx;
    xmax -= dx;
    ymin -= dy;
    ymax -= dy;
    motionx = x;
    motiony = y;
    SetInside();
  }
}

int main(int argc, char **argv)
{
  glutInit(&argc, argv);
  SetUpTextureLevels(argv[1]);

  glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
  glutInitWindowSize(640, 480);
  glutInitWindowPosition(0, 0);
  window = glutCreateWindow("esoview");

  glutDisplayFunc(&DrawGLScene);
  /* glutFullScreen(); */

  glutIdleFunc(&DrawGLScene);
  glutReshapeFunc(&ReSizeGLScene);
  glutKeyboardFunc(&keyPressed);
  glutSpecialFunc(&specialKeyPressed);
  glutMouseFunc(&mouseFunc);
  glutMotionFunc(&motionFunc);
  InitGL(1024, 1024);
  glutMainLoop();

  return 1;
}

