/*

   Split input file of 108199x81503 into 1024x1024 subimages

   The subimage file contains:

   A header structure

   The original file split up into 1024x1024 subimages

   A 50% scale of the image, also in 1024x1024 subimages

   A 25% scale of the image, also in 1024x1024 subimages

   etc.

   until the scaled down image fits 1x1 1024x1024 subimages.

   mk@lemo.dk, 30-oct-2012

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>
#include "../include/smi.h"

main(int argc, char **argv)
{
  unsigned char *inbuf;
  unsigned char *outbuf;
  int in_fd, out_fd, st;
  long i1,i2,i3,i4,i5a,i5b,j1,j2,j3,j4,j5a,j5b,k1,summax;
  long inbase,imagex,imagey,nx,ny,nx2,ny2,imagex2,imagey2,noutside;
  struct SMIFILE *smifile;

  imagex = atoi(argv[3]);
  imagey = atoi(argv[4]);

  smifile = (struct SMIFILE *) malloc(SMI_HEADER_SIZE);
  assert(smifile != NULL);
  smifile->smi_magic = SMI_MAGIC;
  smifile->width = imagex;
  smifile->height = imagey;

  outbuf = (unsigned char *) malloc(SMIX*3*SMIY);
  assert(outbuf != NULL);

  in_fd = open(argv[1], O_RDONLY);
  assert(in_fd >= 0);

  out_fd = open(argv[2], O_RDWR|O_TRUNC|O_CREAT, 0664);
  assert(out_fd >= 0);

  st = write(out_fd, smifile, SMI_HEADER_SIZE);
  assert(st == SMI_HEADER_SIZE);

  inbuf = mmap(NULL, imagex*imagey*3, PROT_READ, MAP_SHARED, in_fd, 0);

  summax = 0;
  noutside = 0;
  for(i1=0; i1<imagey; i1+=SMIY)
  {
    for(j1=0; j1<imagex; j1+=SMIX)
    {
      for(i2=0; i2<SMIY; i2++)
	for(j2=0; j2<SMIX; j2++)
	  for(k1=0; k1<3; k1++)
	  {
	    unsigned char c;
	    if((j1+j2) >= imagex || (i1+i2) >= imagey)
	    {
	      c = 0;
	      noutside++;
	    }
	    else
	      c = inbuf[((i1+i2)*imagex+j1+j2)*3+k1];
	    outbuf[(i2*SMIX+j2)*3+k1] = c;
	    if(c>summax) summax=c;
	  }
      st = write(out_fd, outbuf, SMIX*SMIY*3);
      assert(st == SMIX*SMIY*3);
      printf("i1: %ld, j1: %ld\n", i1, j1);
      fflush(stdout);
    }
  }
  printf("Initial summax: %d\n", summax);
  printf("Initial noutside: %ld\n", noutside);
  munmap(inbuf, imagex*imagey*3);
  close(in_fd);

  inbase = SMI_HEADER_SIZE;
  nx = (imagex+SMIX-1)/SMIX;
  ny = (imagey+SMIY-1)/SMIY;
  while(nx>1 || ny>1)
  {
    imagex2 = imagex/2;
    imagey2 = imagey/2;
    nx2 = (imagex2+SMIX-1)/SMIX;
    ny2 = (imagey2+SMIY-1)/SMIY;
    printf("imagex: %ld imagey: %ld nx: %ld ny: %ld inbase: %ld map: %ld\n", imagex, imagey, nx, ny, inbase, nx*ny*SMIX*SMIY*3);
    fflush(stdout);
    inbuf = mmap(NULL, nx*ny*SMIX*SMIY*3L, PROT_READ, MAP_SHARED, out_fd, inbase);
    summax = 0;
    noutside = 0;
    for(i1=0; i1<ny2; i1++)
      for(j1=0; j1<nx2; j1++)
      {
	printf("i1: %d j1: %d\n", i1, j1);
	fflush(stdout);
	for(i2=0; i2<SMIY; i2++)
	  for(j2=0; j2<SMIX; j2++)
	    for(k1=0; k1<3; k1++)
	    {
	      int sum=0;
	      for(i3=0; i3<2; i3++)
		for(j3=0; j3<2; j3++)
		{
		  j4 = (j1*SMIX + j2)*2+j3;
		  i4 = (i1*SMIY + i2)*2+i3;
		  if(j4 < imagex && i4 < imagey)
		  {
		    j5a = j4/SMIX;
		    j5b = j4%SMIX;
		    i5a = i4/SMIY;
		    i5b = i4%SMIY;
		    /* printf("i1: %d j1: %d i2: %d j2: %d i3: %d j3: %d i4: %d j4: %d i5a: %d i5b: %d j5a: %d j5b: %d k1: %d address: %d\n", 
			i1, j1, i2, j2, i3, j3, i4, j4, i5a, i5b, j5a, j5b, k1, ((i5a*nx+j5a)*SMIX*SMIY+i5b*SMIX+j5b)*3+k1); */
		    sum += inbuf[((i5a*nx+j5a)*SMIX*SMIY+i5b*SMIX+j5b)*3+k1];
		  }
		  else
		    noutside++;
		}
	      sum /= 4;
	      outbuf[(i2*SMIX+j2)*3+k1] = sum;
	      if(sum>summax) summax=sum;
	    }
	st = write(out_fd, outbuf, SMIX*SMIY*3);
	assert (st == SMIX*SMIY*3);
      }
    printf("summax: %d\n", summax);
    printf("noutside: %ld\n", noutside);

    munmap(inbuf, nx*ny*SMIX*SMIY*3);
    inbase += nx*ny*SMIX*SMIY*3;
    imagex = imagex2;
    imagey = imagey2;
    nx = nx2;
    ny = ny2;
  }

  close(out_fd);
}


  
