#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

static int do_debug=1;
static int big=1;
static int disksize;

#define NONSENSE -12341234
static unsigned int REGS[64];
static unsigned char MEM[1024*1024];
static long MEMr[1024*1024];
static long MEMw[1024*1024];
static long MEMx[1024*1024];
static unsigned char *DISK;
static FILE *debug;

static unsigned int eax,ebx,ecx,edx,esi,edi,ebp;

static char *OP_NAMES[32]=
{
"OP_LOAD_B",
"OP_LOAD_H",
"OP_LOAD_W",
"0",
"OP_STORE_B",
"OP_STORE_H",
"OP_STORE_W",
"0",
"OP_ADD",
"OP_MUL",
"OP_DIV",
"OP_NOR",
"0",
"0",
"0",
"0",
"OP_MOVI",
"0",
"OP_CMOV",
"0",
"0",
"0",
"0",
"0",
"OP_IN",
"OP_OUT",
"OP_READ",
"OP_WRITE",
"0",
"0",
"0",
"OP_HALT"};

static unsigned int loadw(unsigned int addr)
{
  unsigned int w;
  if(do_debug)
  {
    if(addr%4!=0) fprintf(debug, "loadw: UNALIGNED: %d\n",addr);
  }
  if(big)
  {
    w = (MEM[addr+3] <<  0) |
	(MEM[addr+2] <<  8) |
	(MEM[addr+1] << 16) |
	(MEM[addr+0] << 24);
  }
  else
  {
    w = (MEM[addr+0] <<  0) |
	(MEM[addr+1] <<  8) |
	(MEM[addr+2] << 16) |
	(MEM[addr+3] << 24);
  }
  return w;
}

static void storew(unsigned int addr,unsigned int word)
{
  if(do_debug)
  {
    if(addr%4!=0) fprintf(debug, "storew: UNALIGNED: %d\n",addr);
  }
  if(big)
  {
    MEM[addr+0] = ((word >> 24)&0xff);
    MEM[addr+1] = ((word >> 16)&0xff);
    MEM[addr+2] = ((word >>  8)&0xff);
    MEM[addr+3] = ((word >>  0)&0xff);
  }
  else
  {
    MEM[addr+3] = ((word >> 24)&0xff);
    MEM[addr+2] = ((word >> 16)&0xff);
    MEM[addr+1] = ((word >>  8)&0xff);
    MEM[addr+0] = ((word >>  0)&0xff);
  }
}


main(int argc, char **argv)
{
  int i,st,fh;
  if(do_debug) debug=fopen("kode.dbg","w");
  for(i=0;i<1024*1024;i++)
  {
    MEMr[i]=0;
    MEMw[i]=0;
    MEMx[i]=0;
  }
  DISK=malloc(100000);
  fh=open("y.out",O_RDONLY);
  if(argc<2)
  {
    fprintf(stderr, "Usage: kode disk1.out\n");
    exit(-1);
  }
  fh=open(argv[1],O_RDONLY);
  disksize=read(fh, DISK, 100000);
  if(do_debug) fprintf(debug,"Read %d chars.\n",disksize);
  close(fh);
  for(i=0; i<sizeof(MEM); i++) MEM[i]=0;
  memcpy((unsigned char *) MEM, (unsigned char *) DISK, 512);
  for(i=0;i<512;i++) MEMw[i]++;
  ecx=0;
  for(i=0; i<63; i++) REGS[i]=NONSENSE;
  REGS[63]=0;

  for(;;)
  {
    edx=REGS[63];
    if(do_debug)
    {
      fprintf(debug,"Address: %d ",edx);
      if(edx%4!=0) fprintf(debug, " UNALIGNED ");
    }
    MEMx[edx]++;
    MEMx[edx+1]++;
    MEMx[edx+2]++;
    MEMx[edx+3]++;
    edx=loadw(edx);
    if(do_debug) fprintf(debug,"Content: %d\n",edx);
    REGS[63]+=4;
    REGS[0]=0;

    ebp=edx;
    ebp>>=21;
    ebp&=077;
    esi=edx;
    esi>>=15;
    esi&=077;
    edi=edx;
    edi>>=9;
    edi&=077;
    eax=edx;
    eax>>=27;
    if(do_debug)
    {
      fprintf(debug,"OP_CODE: %d (%s) ebp: %d esi: %d edi: %d rest: %d", eax,OP_NAMES[eax],ebp,esi,edi,edx&0x1ff);
      for(i=1;i<64;i++)
      {
	if(REGS[i]!=NONSENSE) fprintf(debug, " %d: %d", i, REGS[i]);
      }
      fprintf(debug,"\n");
      fflush(debug);
    }
    switch(eax)
    {
      case  0: /*OP_LOAD_B*/
	eax=REGS[esi];
	eax+=REGS[edi];
	if(do_debug) fprintf(debug, "  LOAD_B: REGS[%d] = MEM[%d] = ", ebp, eax);
	MEMr[eax]++;
	eax=MEM[eax];
	if(do_debug) fprintf(debug, "%d\n", eax);
	REGS[ebp]=eax;
	break;
      case  1: /*OP_LOAD_H*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  2: /*OP_LOAD_W*/
	eax=REGS[esi];
	eax+=REGS[edi];
	if(do_debug) fprintf(debug, "  LOAD_W: REGS[%d] = MEM[%d] = ", ebp, eax);
	MEMr[eax]++;
	MEMr[eax+1]++;
	MEMr[eax+2]++;
	MEMr[eax+3]++;
	eax=loadw(eax);
	if(do_debug) fprintf(debug, "%d\n", eax);
	REGS[ebp]=eax;
	break;
      case  3: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  4: /*OP_STORE_B*/
	eax=REGS[esi];
	eax+=REGS[edi];
	if(do_debug) fprintf(debug, "  STORE_B: MEM[%d] = REGS[%d] = %d\n", eax, ebp, REGS[ebp]);
	MEMw[eax]++;
	MEM[eax]=REGS[ebp];
	break;
      case  5: /*OP_STORE_H*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  6: /*OP_STORE_W*/
	eax=REGS[esi];
	eax+=REGS[edi];
	if(do_debug) fprintf(debug, "  STORE_W: MEM[%d] = REGS[%d] = %d\n", eax, ebp, REGS[ebp]);
	if(do_debug) fflush(debug);
	MEMw[eax]++;
	MEMw[eax+1]++;
	MEMw[eax+2]++;
	MEMw[eax+3]++;
	storew(eax,REGS[ebp]);
	break;
      case  7: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  8: /*OP_ADD*/
	if(do_debug) fprintf(debug,"OP_ADD: REGS[%d] = REGS[%d](%d)+REGS[%d](%d) = ",ebp,esi,REGS[esi],edi,REGS[edi]);
	eax=REGS[esi];
	eax=eax+REGS[edi];
	REGS[ebp]=eax;
	if(do_debug) fprintf(debug,"%d\n",eax);
	break;
      case  9: /*OP_MUL*/
	if(do_debug) fprintf(debug,"OP_MUL: REGS[%d] = REGS[%d](%d)*REGS[%d](%d) = ",ebp,esi,REGS[esi],edi,REGS[edi]);
	eax=REGS[esi];
	eax=eax*REGS[edi];
	REGS[ebp]=eax;
	if(do_debug) fprintf(debug,"%d\n",eax);
	break;
      case 10: /*OP_DIV*/
	if(do_debug) fprintf(debug,"OP_DIV: REGS[%d] = REGS[%d](%d)/REGS[%d](%d) = ",ebp,esi,REGS[esi],edi,REGS[edi]);
	eax=REGS[esi];
	eax=eax/REGS[edi];
	REGS[ebp]=eax;
	if(do_debug) fprintf(debug,"%d\n",eax);
	break;
	break;
      case 11: /*OP_NOR*/
	if(do_debug) fprintf(debug,"OP_NOR: REGS[%d] = !(REGS[%d](%d)|REGS[%d](%d)) = ",ebp,esi,REGS[esi],edi,REGS[edi]);
	eax=REGS[esi];
	eax=~(eax|REGS[edi]);
	REGS[ebp]=eax;
	if(do_debug) fprintf(debug,"%d\n",eax);
	break;
	break;
      case 12: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 13: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 14: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 15: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 16: /*OP_MOVI*/
	eax=edx;
	ecx=edx;
	eax>>=5;
	eax&=0xffff;
	ecx&=037;
	eax<<=ecx;
	if(do_debug) fprintf(debug,"  MOVI: REGS[%d]=%d\n", ebp, eax);
	REGS[ebp]=eax;
	break;
      case 17: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 18: /*OP_CMOV*/
	eax=REGS[edi];
	if(do_debug) fprintf(debug, "  CMOV: REGS[%d]: %d\n", edi, eax);
	if(eax)
	{
	  eax=REGS[esi];
	  REGS[ebp]=eax;
	  if(do_debug) fprintf(debug, "  True: REGS[%d]=REGS[%d]: %d\n", ebp, esi, eax);
	}
	break;
      case 19: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 20: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 21: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 22: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 23: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 24: /*OP_IN*/
	REGS[ebp]=getchar();
	if(do_debug) fprintf(debug,"input REGS[%d]=%d: %c\n",ebp,REGS[ebp],(char) REGS[ebp]);
	break;
      case 25: /*OP_OUT*/
	if(do_debug) fprintf(debug,"putchar %d: %c\n",REGS[ebp],(char) REGS[ebp]);
	printf("%c", (char) REGS[ebp]);
	fflush(stdout);
	break;
      case 26: /*OP_READ*/
	ecx=0x200;
	esi=REGS[esi];
	esi<<=9;
	edi=REGS[ebp];
        if(do_debug) fprintf(debug,"READ: MEM[%d] = DISK[%d]\n", edi, esi);
	if(do_debug) fflush(debug);
	memcpy((unsigned char *) MEM+edi, (unsigned char *) DISK+esi, ecx);
	for(i=0;i<ecx;i++) MEMw[edi+i]++;
	break;
      case 27: /*OP_WRITE*/
	ecx=0x200;
	esi=REGS[esi];
	esi<<=9;
	edi=REGS[ebp];
        if(do_debug) fprintf(debug,"WRITE: DISK[%d] = MEM[%d]\n", esi, edi);
	if(do_debug) fflush(debug);
	memcpy((unsigned char *) DISK+esi, (unsigned char *) MEM+edi, ecx);
	for(i=0;i<ecx;i++) MEMr[edi+i]++;
	break;
      case 28: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 29: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 30: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 31: /*OP_HALT*/
	if(do_debug)
	{
	  fh=open("MEM.dmp",O_WRONLY|O_CREAT|O_TRUNC,0755);
	  write(fh,MEM,sizeof(MEM));
	  close(fh);
	  for(i=0;i<1024*1024;i++)
	  {
	    if(MEMr[i]+MEMw[i]+MEMx[i]>0)
	    {
	      fprintf(debug,"%d\t%d\t%d\t%d\n",i,MEMr[i],MEMw[i],MEMx[i]);
	    }
	  }
	  for(i=0;i<64;i++)
	  {
	    if(REGS[i]!=NONSENSE) fprintf(debug, "REGS[%d] = %d\n", i, REGS[i]);
	  }
	}
	fh=open("diskout.img",O_WRONLY|O_CREAT|O_TRUNC,0755);
	write(fh,DISK,100000);
	close(fh);
	exit(0);
        break;
    }
  }
}
