#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <byteswap.h>

static int disksize;

static unsigned char MEM[1024*1024];
static unsigned char *DISK,*DISKorig;

static unsigned int loadw(unsigned int addr)
{
  unsigned int w;
  w = *(unsigned int *)(MEM+addr);
  w = bswap_32(w);
  return w;
}

static void storew(unsigned int addr,unsigned int w)
{
  *(unsigned int *)(MEM+addr) = bswap_32(w);
}


main(int argc, char **argv)
{
  int i,st,fh;
  unsigned int eax,ebx,ecx,edx,esi,edi,ebp;
  unsigned int REGS[64];

  DISK=malloc(100000);
  DISKorig=malloc(100000);
  if(argc<2)
  {
    fprintf(stderr, "Usage: kode disk1.out\n");
    exit(-1);
  }
  fh=open(argv[1],O_RDONLY);
  disksize=read(fh, DISKorig, 100000);
  close(fh);
again:
  memcpy((unsigned char *) DISK, (unsigned char *) DISKorig,disksize);
  memcpy((unsigned char *) MEM, (unsigned char *) DISK, 512);
  ecx=0;
  for(i=0; i<64; i++) REGS[i]=0;

  for(;;)
  {
    edx=REGS[63];
    edx=loadw(edx);
    REGS[63]+=4;
    REGS[0]=0;

    ebp=edx;
    ebp>>=21;
    ebp&=077;
    esi=edx;
    esi>>=15;
    esi&=077;
    edi=edx;
    edi>>=9;
    edi&=077;
    eax=edx;
    eax>>=27;
    switch(eax)
    {
      case  0: /*OP_LOAD_B*/
	eax=REGS[esi];
	eax+=REGS[edi];
	eax=MEM[eax];
	REGS[ebp]=eax;
	break;
      case  1: /*OP_LOAD_H*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  2: /*OP_LOAD_W*/
	eax=REGS[esi];
	eax+=REGS[edi];
	eax=loadw(eax);
	REGS[ebp]=eax;
	break;
      case  3: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  4: /*OP_STORE_B*/
	eax=REGS[esi];
	eax+=REGS[edi];
	MEM[eax]=REGS[ebp];
	break;
      case  5: /*OP_STORE_H*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  6: /*OP_STORE_W*/
	eax=REGS[esi];
	eax+=REGS[edi];
	storew(eax,REGS[ebp]);
	break;
      case  7: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case  8: /*OP_ADD*/
	eax=REGS[esi];
	eax=eax+REGS[edi];
	REGS[ebp]=eax;
	break;
      case  9: /*OP_MUL*/
	eax=REGS[esi];
	eax=eax*REGS[edi];
	REGS[ebp]=eax;
	break;
      case 10: /*OP_DIV*/
	eax=REGS[esi];
	eax=eax/REGS[edi];
	REGS[ebp]=eax;
	break;
      case 11: /*OP_NOR*/
	eax=REGS[esi];
	eax=~(eax|REGS[edi]);
	REGS[ebp]=eax;
	break;
      case 12: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 13: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 14: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 15: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 16: /*OP_MOVI*/
	eax=edx;
	ecx=edx;
	eax>>=5;
	eax&=0xffff;
	ecx&=037;
	eax<<=ecx;
	REGS[ebp]=eax;
	break;
      case 17: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 18: /*OP_CMOV*/
	eax=REGS[edi];
	if(eax)
	{
	  eax=REGS[esi];
	  REGS[ebp]=eax;
	}
	break;
      case 19: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 20: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 21: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 22: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 23: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 24: /*OP_IN*/
	REGS[ebp]=getchar();
	if(REGS[ebp]==EOF) exit(0);
	printf("%c", (char) REGS[ebp]);
	break;
      case 25: /*OP_OUT*/
	printf("%c", (char) REGS[ebp]);
	break;
      case 26: /*OP_READ*/
	ecx=0x200;
	esi=REGS[esi];
	esi<<=9;
	edi=REGS[ebp];
	memcpy((unsigned char *) MEM+edi, (unsigned char *) DISK+esi, ecx);
	break;
      case 27: /*OP_WRITE*/
	ecx=0x200;
	esi=REGS[esi];
	esi<<=9;
	edi=REGS[ebp];
	memcpy((unsigned char *) DISK+esi, (unsigned char *) MEM+edi, ecx);
	break;
      case 28: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 29: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 30: /*0*/
	fprintf(stderr, "Not implemented opcode: %d\n",eax);
	exit(0);
	break;
      case 31: /*OP_HALT*/
	fflush(stdout);
	goto again;
	fh=open("diskout.img",O_WRONLY|O_CREAT|O_TRUNC,0755);
	write(fh,DISK,100000);
	close(fh);
	exit(0);
        break;
    }
  }
}
