#include <math.h>
#include <omp.h>
#include <stdio.h>
#include "neunet.h"
#include <stdlib.h>

extern int n_hidden,n_input,n_output,n_learn,n_test,dy,dx;

extern double hidden_weight[MAX_hidden][MAX_input],
	      hidden_delta[MAX_hidden],
	      hidden_output[MAX_hidden],
	      hidden_data[MAX_hidden][MAX_input],
	      output_weight[MAX_output][MAX_hidden],
	      output_delta[MAX_output],
	      output_output[MAX_output],
              output_data[MAX_output][MAX_hidden],
	      input[MAX_input],result[MAX_output];

extern int *test_input_data, *test_output_data, *charrow, *charpos;
extern double momentum, learning_rate;

static char chartable[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

main(argc,argv)
int argc;
char **argv;
{
  int i,j,k,l,m,n,nbad,seed,n_learn;
  long time1,time2,dtime;
  double drand48();
  double ssq,diff;
  int *pinput;
  FILE *IN,*INNET;

  if(argc<3)
  {
    printf("Usage: analyse <inputnetwork> <inputdata>\n");
    exit(-1);
  }

  INNET=fopen(argv[1],"r");
  read_network(INNET);
  fclose(INNET);
  IN=fopen(argv[2],"r");
  read_training(IN);
  fclose(IN);

  ssq=0;
  nbad=0;

  for(j=0;j<n_test;j++)
  {
    for(l=0;l<n_input;l++) input[l]=test_input_data[j*n_input+l]/318.75+0.1;
    for(l=0;l<n_output;l++) result[l]=(test_output_data[j]==l)?0.9:0.1;

    propagate();
    m=0;
    for(l=1;l<n_output;l++)
    {
      if(output_output[l]>output_output[m]) m=l;
    }
    if(test_output_data[j]!=m)
    {
      printf("---\n");
      printf("BAD:\tShould be: %d(%c)\tis: %d(%c)\t%d\t%d\n",test_output_data[j],chartable[test_output_data[j]],m,chartable[m],charrow[j],charpos[j]);
      for(l=0;l<64;l++)
	printf("%d\t%c\t%.6lf\n",l,chartable[l],output_output[l]);
      printf("---\n");
      nbad++;
    }

    for(l=0;l<n_output;l++) 
    {
      diff=result[l]-output_output[l];
      ssq+=diff*diff;
    }
  }
  printf("%d\t%lg\n",nbad,ssq);
}

