#include <math.h>
#include <omp.h>
#include <stdio.h>
#include "neunet.h"
#include <stdlib.h>

extern int n_hidden,n_input,n_output,n_learn,n_test,dy,dx;

extern int *test_input_data, *test_output_data, *charrow, *charpos;

main(argc,argv)
int argc;
char **argv;
{
  int i,j,k,l,m,n,o,divide,ipnt;
  FILE *IN,*OUT;
  int nchar[64];
  int firstchar[64];
  int n_test_new, *test_input_data_new, *test_output_data_new, *charrow_new, *charpos_new;

  if(argc<5)
  {
    printf("Usage: divide <inputfile> <divide> <n> <outputfile>\n");
    exit(-1);
  }

  sscanf(argv[2],"%d",&divide);
  sscanf(argv[3],"%d",&n);

  /*

  Read input.

  */

  IN=fopen(argv[1],"r");
  read_training(IN);
  fclose(IN);

  /*
  
  Count:

  */

  for(i=0;i<64;i++)
  {
    nchar[i]=0;
    firstchar[i]=-1;
  }
  for(i=0;i<n_test;i++)
  {
    j=test_output_data[i];
    nchar[j]++;
    if(firstchar[j]==-1) firstchar[j]=i;
  }

  n_test_new = 0;
  for(i=0;i<64;i++)
  {
    j=nchar[i];
    if(n==divide)
    {
      k=(j+divide-1)/divide;
    }
    else
    {
      k=j/divide;
    }
    n_test_new+=k;
  }
  test_input_data_new=malloc(sizeof(*test_input_data_new)*n_test_new*dy*dx);
  test_output_data_new=malloc(sizeof(*test_output_data_new)*n_test_new);
  charrow_new=malloc(sizeof(*charrow_new)*n_test_new);
  charpos_new=malloc(sizeof(*charpos_new)*n_test_new);
  ipnt=0;
  for(i=0;i<64;i++)
  {
    j=nchar[i];
    if(n==divide)
    {
      k=(j+divide-1)/divide;
    }
    else
    {
      k=j/divide;
    }
    m=firstchar[i]+j/divide*(n-1);
    for(l=0;l<k;l++)
    {
      for(o=0;o<dx*dy;o++)
	test_input_data_new[ipnt*dx*dy+o]=test_input_data[(m+l)*dx*dy+o];
      test_output_data_new[ipnt]=test_output_data[m+l];
      charrow_new[ipnt]=charrow[m+l];
      charpos_new[ipnt]=charpos[m+l];
      ipnt++;
    }
  }
  if(ipnt!=n_test_new) exit(-1);
  free(charpos);
  free(charrow);
  free(test_output_data);
  free(test_input_data);
  test_input_data=test_input_data_new;
  test_output_data=test_output_data_new;
  charrow=charrow_new;
  charpos=charpos_new;
  n_test=n_test_new;

  OUT=fopen(argv[4],"w");
  write_training(OUT);
  fclose(OUT);
}

