#!/bin/bash

./divide ../nndata.txt 2 1 nndata1.txt
./divide ../nndata.txt 2 2 nndata2.txt

rm -f train*.log analyse*.log

for seed in {900..999}
do
  echo Learn seed: $seed
  ./learn nndata1.txt $seed 128 0.1 0.05 5000 network${seed}.txt >train${seed}.log &
done
wait

for seed in {900..999}
do
  echo Analyse seed: $seed
  ./analyse network${seed}.txt nndata2.txt >analyse${seed}.log &
done
wait
wc analyse*.log | sort -n | while read line
do
  file=`echo $line|sed -e 's/^.*analyse/train/g'`
  echo $file|fgrep -q train
  if [ $? -eq 0 ]
  then
    echo $line `tail -1 $file`
  else
    echo $line
  fi
done >run9


