#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "neunet.h"

int n_hidden,n_input,n_output,n_test,dy,dx;
int *test_input_data, *test_output_data, *charrow, *charpos;

double hidden_weight[MAX_hidden][MAX_input],
	      hidden_delta[MAX_hidden],
	      hidden_output[MAX_hidden],
	      hidden_data[MAX_hidden][MAX_input],
	      output_weight[MAX_output][MAX_hidden],
	      output_delta[MAX_output],
	      output_output[MAX_output],
              output_data[MAX_output][MAX_hidden],
	      input[MAX_input],result[MAX_output];

double momentum, learning_rate;

propagate()
{
  register int i,j;

  /*  Propagate hidden  */

  for(i=0; i<n_hidden; i++)
  {
    double temp;
    temp=0.0;
    for(j=0; j<n_input; j++)
    {
      temp+=input[j]*hidden_weight[i][j];
    }
    hidden_output[i]=1.0/(1.0+exp(-temp));
  }

  /*  Propagate output */

  for(i=0; i<n_output; i++)
  {
    double sum;
    sum=0.0;
    for(j=0; j<n_hidden; j++)
    {
      sum+=hidden_output[j]*output_weight[i][j];
    }
    output_output[i]=1.0/(1.0+exp(-sum));
  }
}

back_propagate()
{
  register int i,j;

  /*  delta output  */

  for(i=0; i<n_output; i++)
  {
    output_delta[i]=(result[i]-output_output[i])*
		    (1.0-output_output[i])*output_output[i];
  }

  /*  delta hidden  */

  for(i=0; i<n_hidden; i++)
  {
    double error_sum;
    error_sum=0.0;
    for(j=0; j<n_output; j++)
    {
      error_sum+=output_weight[j][i]*output_delta[j];
    }
    hidden_delta[i]=hidden_output[i]*(1.0-hidden_output[i])*
		    error_sum;
  }

  /*  adjust output  */

  for(i=0; i<n_output; i++)
  {
    for(j=0; j<n_hidden; j++)
    {
      output_data[i][j]=(learning_rate*output_delta[i]*
			 hidden_output[j])+(momentum*
			 output_data[i][j]);
      output_weight[i][j]+=output_data[i][j];
    }
  }

  /*  adjust hidden  */

  for(i=0; i<n_hidden; i++)
  {
    for(j=0; j<n_input; j++)
    {
      hidden_data[i][j]=(learning_rate*hidden_delta[i]*
			 input[j])+(momentum*hidden_data[i][j]);
      hidden_weight[i][j]+=hidden_data[i][j];
    }
  }
}

void read_network(FILE *IN)
{
  int i,j;
  fscanf(IN, "%d\t%d\t%d\n", &n_input, &n_hidden, &n_output);
  if(n_input>MAX_input)
  {
    fprintf(stderr, "n_input (%d) > MAX_input (%d).\n",n_input,MAX_input);
    exit(-1);
  }
  if(n_hidden>MAX_hidden)
  {
    fprintf(stderr, "n_hidden (%d) > MAX_hidden (%d).\n",n_hidden,MAX_hidden);
    exit(-1);
  }
  if(n_output>MAX_output)
  {
    fprintf(stderr, "n_output (%d) > MAX_output (%d).\n",n_output,MAX_output);
    exit(-1);
  }
  for(i=0;i<n_input;i++)
    for(j=0;j<n_hidden;j++)
      fscanf(IN,"%lg",&hidden_weight[j][i]);
  for(i=0;i<n_hidden;i++)
    for(j=0;j<n_output;j++)
      fscanf(IN,"%lg",&output_weight[j][i]);
}

void write_network(FILE *OUT)
{
  int i,j;
  fprintf(OUT,"%d\t%d\t%d\n",n_input,n_hidden,n_output);
  for(i=0;i<n_input;i++)
    for(j=0;j<n_hidden;j++)
      fprintf(OUT,"%.16lg\n",hidden_weight[j][i]);
  for(i=0;i<n_hidden;i++)
    for(j=0;j<n_output;j++)
      fprintf(OUT,"%.16lg\n",output_weight[j][i]);
}

void read_training(FILE *IN)
{
  int i,j,k;
  fscanf(IN,"%d\t%d\t%d\n",&n_test,&dy,&dx);
  test_input_data=malloc(sizeof(*test_input_data)*n_test*dy*dx);
  test_output_data=malloc(sizeof(*test_output_data)*n_test);
  charrow=malloc(sizeof(*charrow)*n_test);
  charpos=malloc(sizeof(*charpos)*n_test);
  for(i=0;i<n_test;i++)
  {
    fscanf(IN,"%d\t%d\t%d\n",&test_output_data[i],&charrow[i],&charpos[i]);
    for(j=0;j<dy;j++)
    {
      for(k=0;k<dx;k++)
      {
	fscanf(IN,"%d",&test_input_data[i*dy*dx+j*dx+k]);
      }
    }
  }
}

void write_training(FILE *OUT)
{
  int i,j,k;
  fprintf(OUT,"%d\t%d\t%d\n", n_test, dy, dx);
  for(i=0;i<n_test;i++)
  {
    fprintf(OUT,"%d\t%d\t%d\n",test_output_data[i],charrow[i],charpos[i]);
    for(j=0;j<dy;j++)
    {
      for(k=0;k<dx;k++)
      {
	fprintf(OUT,"%d\t",test_input_data[i*dy*dx+j*dx+k]);
      }
      fprintf(OUT,"\n");
    }
  }
  fprintf(OUT,"-1\n");
}

