#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <wand/MagickWand.h>
#include <gd.h>

static char base64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static int xmin,ymin,xmax,ymax;
static size_t width,height;
static unsigned char *inputmap;

#define pixel(row,col) (inputmap[(row)*width+(col)])

#define ThrowViewException(view) \
{ \
  ExceptionType severity; \
  char *description; \
  description=GetWandViewException(view,&severity); \
  (void) fprintf(stderr,"%s %s %lu %s\n",GetMagickModule(),description); \
  description=(char *) MagickRelinquishMemory(description); \
  exit(-1); \
}
#define ThrowWandException(wand) \
{ \
  ExceptionType severity; \
  char *description; \
  description=MagickGetException(wand,&severity); \
  (void) fprintf(stderr,"%s %s %lu %s\n",GetMagickModule(),description); \
  description=(char *) MagickRelinquishMemory(description); \
  exit(-1); \
}



void readbitmap()
{
  int i,j;
  MagickWand *image;
  MagickBooleanType status;
  PixelIterator *iterator;
  MagickPixelPacket pxl;
  PixelWand **pixels;
  
  image=NewMagickWand();
  status=MagickReadImage(image,"hacker-opgave2017.bmp");
  if(status==MagickFalse) ThrowWandException(image);
  width=MagickGetImageWidth(image);
  height=MagickGetImageHeight(image);
  xmin=0;
  ymin=0;
  xmax=width-1;
  ymax=height-1;
  inputmap = (unsigned char *) malloc(width*height);
  assert(inputmap);
  iterator=NewPixelIterator(image);
  if(iterator==(PixelIterator *) NULL) ThrowWandException(image);
  for(j=0;j<height;j++)
  {
    pixels=PixelGetNextIteratorRow(iterator,&width);
    if (pixels == (PixelWand **) NULL) break;
    for(i=0;i<width;i++)
    {
      PixelGetMagickColor(pixels[i],&pxl);
      pixel(j,i)=pxl.red/257;
    }
  }
  iterator=DestroyPixelIterator(iterator);
  image=DestroyMagickWand(image);
}

#define DX 10
#define DY 20
#define MAXCHAR 2000
#define NCHAR 64
#define MAXROWS 1000
#define MAXLINE 30
#define SCALEFACTOR 10
static int dytop=4;
static int dybottom=7;

/* charcount[NCHAR] */
static int *charcount;
/* charrow[NCHAR][MAXCHAR] */
static int *charrow;
/* charpos[NCHAR][MAXCHAR] */
static int *charpos;
/* charx[NCHAR][MAXCHAR] */
static int *charx;
/* chary[NCHAR][MAXCHAR] */
static int *chary;
/* charxend[NCHAR][MAXCHAR] */
static int *charxend;
/* charyend[NCHAR][MAXCHAR] */
static int *charyend;
/* rowxmin[MAXROWS] */
static int *rowxmin;
/* rowxmax[MAXROWS] */
static int *rowxmax;
/* rowymin[MAXROWS] */
static int *rowymin;
/* rowymax[MAXROWS] */
static int *rowymax;
static int rowno=0;

void findcharacters()
{
  int imagerowno=0;
  double real_dy=13.9118;
  int xbase=1761;
  int xbasedelta=291;
  int first=1;
  int i,x,y,x2,y2,sum,yend,cp,pos,ichar,xend,xendvalue;
  FILE *TEXT;
  char line[80];
  char chr,*pchr;
  int *sumy,*sumx;
  charcount = (int *) malloc(sizeof(*charcount)*NCHAR);
  for(i=0;i<NCHAR;i++) charcount[i]=0;
  charrow = (int *) malloc(sizeof(*charrow)*NCHAR*MAXCHAR);
  charpos = (int *) malloc(sizeof(*charpos)*NCHAR*MAXCHAR);
  charx = (int *) malloc(sizeof(*charx)*NCHAR*MAXCHAR);
  chary = (int *) malloc(sizeof(*chary)*NCHAR*MAXCHAR);
  charxend = (int *) malloc(sizeof(*charxend)*NCHAR*MAXCHAR);
  charyend = (int *) malloc(sizeof(*charyend)*NCHAR*MAXCHAR);
  rowxmin = (int *) malloc(sizeof(*rowxmin)*MAXROWS);
  for(i=0;i<MAXROWS;i++) rowxmin[i]=-1;
  rowxmax = (int *) malloc(sizeof(*rowxmax)*MAXROWS);
  rowymin = (int *) malloc(sizeof(*rowymin)*MAXROWS);
  rowymax = (int *) malloc(sizeof(*rowymax)*MAXROWS);
  sumy = (int *) malloc(sizeof(*sumy)*height);
  sumx = (int *) malloc(sizeof(*sumx)*width);
  TEXT=fopen("opgave.txt","r");
  assert(TEXT);
  for(;;)
  {
    fgets(line, sizeof(line)-1, TEXT);
    rowno++;
    if(line[strlen(line)-1]=='\n') line[strlen(line)-1]=0;
    if(strlen(line)==0)
    {
      xbase += xbasedelta;
      first = 1;
      fgets(line, sizeof(line)-1, TEXT);
      rowno++;
      if(line[strlen(line)-1]=='\n') line[strlen(line)-1]=0;
      imagerowno=0;
      if(strlen(line)==0) break;
    }
    x=xbase;
    if(first)
    {
      for(y2=ymin;y2<=ymax;y2++)
      {
	sum=0;
	for(x2=0;x2<MAXLINE*(DX-0.5);x2++)
	{
	  sum += 255-pixel(y2,x+x2);
	}
	sumy[y2]=sum;
      }
      first=0;
      y=ymin;
    }
restartline:
    imagerowno++;
    yend=DY-1;
    y = (imagerowno-1)*real_dy+7;
    if(sumy[y+6]==0 && sumy[y+7]==0)
    {
      /* blank line */
      goto restartline;
    }
    for(x2=0;x2<MAXLINE*(DX-0.5);x2++)
    {
      sumx[x2]=0;
    }
    for(y2=dytop;y2<(DY-dybottom);y2++)
    {
      for(x2=0;x2<MAXLINE*(DX-0.5);x2++)
      {
	sumx[x2] += 255-pixel(y+y2,x+x2);
      }
    }
    rowxmin[rowno]=x;
    rowxmax[rowno]=x+MAXLINE*(DX-0.5)-1;
    rowymin[rowno]=y;
    rowymax[rowno]=y+DY-1;
    for(cp=0;cp<strlen(line);cp++)
    {
      chr = line[cp];
      if(chr=='_') continue;
      pchr = index(base64,chr);
      if(pchr==NULL) continue;
      pos=pchr-base64;
      ichar = charcount[pos];
      charrow[pos*MAXCHAR+ichar]=rowno;
      charpos[pos*MAXCHAR+ichar]=cp;
      while(sumx[x-xbase]==0) x++;
      xend=6;
      xendvalue=sumx[x-xbase+xend];
      for(x2=7;x2<DX;x2++)
      {
	if(sumx[x-xbase+x2]<xendvalue)
	{
	  xend=x2;
	  xendvalue=sumx[x-xbase+x2];
	}
      }
      charx[pos*MAXCHAR+ichar]=x;
      chary[pos*MAXCHAR+ichar]=y;
      charxend[pos*MAXCHAR+ichar]=xend;
      charyend[pos*MAXCHAR+ichar]=yend;
      charcount[pos]++;
      x += xend+1;
    }
  }
}

void writerows()
{
  MagickWand *image;
  MagickBooleanType status;
  PixelIterator *iterator;
  MagickPixelPacket pxl;
  char filename[11];
  int i,j,rwidth,rheight,x,y;
  char *pixels;
  for(i=1;i<=rowno;i++)
  {
    if(rowxmin[i]==-1) continue;
    rwidth=rowxmax[i]-rowxmin[i]+1;
    rheight=rowymax[i]-rowymin[i]+1;
    pixels = malloc(rwidth*rheight);
    assert(pixels);
    for(y=0;y<rheight;y++)
    {
      for(x=0;x<rwidth;x++)
      {
	pixels[y*rwidth+x]=pixel(y+rowymin[i],x+rowxmin[i]);
      }
    }
    image = NewMagickWand();
    status = MagickConstituteImage(image,rwidth,rheight,"I",CharPixel,pixels);
    if(status==MagickFalse) ThrowWandException(image);
    sprintf(filename,"row%03d.png",i);
    status=MagickWriteImages(image,filename,MagickTrue);
    if (status == MagickFalse) ThrowWandException(image);
    image=DestroyMagickWand(image);
    free(pixels);
  }
}

void writecharimgs()
{
  int x2,y2,xend,yend,pos,ichar,x,y,i,j,iwidth1,iheight1,p,iwidth2,iheight2;
  MagickWand *image;
  DrawingWand *draw;
  MagickBooleanType status;
  PixelIterator *iterator;
  MagickPixelPacket pxl;
  char *pixels;
  char filename[10];
  char buffer[80];
  for(i=0;i<NCHAR;i++)
  {
    pos=charcount[i];
    iwidth1=2*DX;
    iheight1=DY*pos;
    pixels=malloc(iwidth1*iheight1);
    for(j=0;j<pos;j++)
    {
      x=charx[i*MAXCHAR+j];
      y=chary[i*MAXCHAR+j];
      xend=charxend[i*MAXCHAR+j];
      yend=charyend[i*MAXCHAR+j];
      for(y2=0;y2<DY;y2++)
      {
	for(x2=0;x2<DX;x2++)
	{
	  if(x2>=xend || y2>=yend)
	  {
	    p=255;
	  }
	  else
	  {
	    p=pixel(y+y2,x+x2);
	  }
	  pixels[(DY*j+y2)*iwidth1+x2]=p;
	  pixels[(DY*j+y2)*iwidth1+x2+DX]=255;
	}
      }
    }
    iwidth2=2*DX*SCALEFACTOR;
    iheight2=DY*pos*SCALEFACTOR;
    sprintf(filename,"img%02d.png",i);
    image = NewMagickWand();
    status = MagickConstituteImage(image,iwidth1,iheight1,"I",CharPixel,pixels);
    if(status==MagickFalse) ThrowWandException(image);
    /* scale image to make room for annotations */
    MagickResetIterator(image);
    while(MagickNextImage(image) != MagickFalse)
     MagickResizeImage(image,iwidth2,iheight2,CubicFilter,1.0);
    /* Annotate image */
    draw = NewDrawingWand();
    for(j=0;j<pos;j++)
    {
      DrawLine(draw,0,DY*SCALEFACTOR*(j+1)-1,DX*2*SCALEFACTOR,DY*SCALEFACTOR*(j+1)-1);
      sprintf(buffer,"Row: %d",charrow[i*MAXCHAR+j]);
      DrawAnnotation(draw,DX*SCALEFACTOR*1.1,DY*SCALEFACTOR*(j+0.3),buffer);
      sprintf(buffer,"Pos: %d",charpos[i*MAXCHAR+j]+1);
      DrawAnnotation(draw,DX*SCALEFACTOR*1.1,DY*SCALEFACTOR*(j+0.5),buffer);
    }
    MagickDrawImage(image, draw);
    /* Write image */
    status=MagickWriteImages(image,filename,MagickTrue);
    if (status == MagickFalse) ThrowWandException(image);
    draw=DestroyDrawingWand(draw);
    image=DestroyMagickWand(image);
    free(pixels);
  }
}

void writeredimage()
{
  MagickWand *image;
  MagickBooleanType status;
  PixelIterator *iterator;
  MagickPixelPacket pxl;
  int i,j,x,y,pos,y2;
  char *pixels,pred,pgreen,pblue;
  pixels = malloc(width*height*3);
  assert(pixels);
  for(y=0;y<height;y++)
    for(x=0;x<width;x++)
    {
      pixels[(y*width+x)*3+0]=pixel(y,x);
      pixels[(y*width+x)*3+1]=pixel(y,x);
      pixels[(y*width+x)*3+2]=pixel(y,x);
    }
  for(i=0;i<NCHAR;i++)
  {
    pos=charcount[i];
    for(j=0;j<pos;j++)
    {
      x=charx[i*MAXCHAR+j];
      y=chary[i*MAXCHAR+j];
      for(y2=0;y2<DY;y2++)
      {
	pred=0;
	pgreen=0;
	pblue=0;
	if(y2>=dytop && y2<DY-dybottom)
	{
	  pred=255;
	}
	else
	{
	  pblue=255;
	}
	pixels[((y+y2)*width+x)*3+0]=pred;
	pixels[((y+y2)*width+x)*3+1]=pgreen;
	pixels[((y+y2)*width+x)*3+2]=pblue;
      }
    }
  }

  image = NewMagickWand();
  status = MagickConstituteImage(image,width,height,"RGB",CharPixel,pixels);
  if(status==MagickFalse) ThrowWandException(image);
  status=MagickWriteImages(image,"redmarks.png",MagickTrue);
  if (status == MagickFalse) ThrowWandException(image);
  image=DestroyMagickWand(image);
  free(pixels);
}

void writenndata()
{
  int i,j,pos,total,x,y,x2,y2,xend,yend,p;
  FILE *OUT;
  OUT=fopen("nndata.txt","w");
  assert(OUT);
  total=0;
  for(i=0;i<NCHAR;i++) total+=charcount[i];
  fprintf(OUT,"%d\t%d\t%d\n",total,DY,DX);

  for(i=0;i<NCHAR;i++)
  {
    pos=charcount[i];
    for(j=0;j<pos;j++)
    {
      fprintf(OUT,"%d\t%d\t%d\n",i,charrow[i*MAXCHAR+j],charpos[i*MAXCHAR+j]+1);
      x=charx[i*MAXCHAR+j];
      y=chary[i*MAXCHAR+j];
      xend=charxend[i*MAXCHAR+j];
      yend=charyend[i*MAXCHAR+j];
      for(y2=0;y2<DY;y2++)
      {
	for(x2=0;x2<DX;x2++)
	{
	  if(x2>=xend || y2>=yend)
	    p=0;
	  else
	    p=255-pixel(y+y2,x+x2);
	  fprintf(OUT,"%d\t",p);
	}
	fprintf(OUT,"\n");
      }
    }
  }
  fprintf(OUT,"-1\n");
  fclose(OUT);
}


void main()
{
  MagickWandGenesis();
  readbitmap();
  findcharacters();
  writerows();
  writeredimage();
  writenndata();
  writecharimgs();
}


