section	.text
global _start

%define REG(r) [REGS + r * 4]
%define PTR(p) [MEM + p]

_start:
;
;	Read infile (disk.img) to DISK:
;
    mov ebx,infile
    mov ecx,0		; O_RDONLY
    mov edx,0		; mode
    mov eax,5		; sys_open
    int 0x80
    mov [fd],eax        ; fd=open("disk.img",O_RDONLY);
    mov ebx,[fd]
    mov ecx,DISK
    mov edx,100000	; read(fd,DISK,100000);
    mov eax,3
    int 0x80
    
;
; 	start of program:
;
start:
    mov ecx, 0x200
    mov edi, MEM
    mov esi, DISK
    cld
    rep movsb
    mov edi, REGS
    mov ecx, 64
    mov eax, 0
    rep stosd
SPIN:
    mov edx, REG(63)
    mov edx, PTR(edx)
    bswap edx
    add WORD REG(63), 4
    mov WORD REG(0), 0

    mov ebp, edx
    shr ebp, 21
    and ebp, 77o
    mov esi, edx
    shr esi, 15
    and esi, 77o
    mov edi, edx
    shr edi, 9
    and edi, 77o

    mov eax, edx
    shr eax, 27
    mov eax, [OP_TABLE + eax * 4]
    jmp eax


OP_TABLE:
    dd OP_LOAD_B, OP_LOAD_H, OP_LOAD_W, 0, OP_STORE_B, OP_STORE_H, OP_STORE_W, \
    0, OP_ADD, OP_MUL, OP_DIV, OP_NOR, 0, 0, 0, 0, OP_MOVI, 0, OP_CMOV, 0, 0,  \
    0, 0, 0, OP_IN, OP_OUT, OP_READ, OP_WRITE, 0, 0, 0, OP_HALT

OP_LOAD_B:
    mov eax, REG(esi)
    add eax, REG(edi)
    mov ecx, 0
    mov cl, BYTE PTR(eax)
    mov REG(ebp), ecx
    jmp SPIN

OP_LOAD_H:
    jmp SPIN

OP_LOAD_W:
    mov eax, REG(esi)
    add eax, REG(edi)
    mov eax, PTR(eax)
    bswap eax
    mov REG(ebp), eax
    jmp SPIN

OP_STORE_B:
    mov eax, REG(esi)
    add eax, REG(edi)
    mov ecx, REG(ebp)
    mov BYTE PTR(eax), cl
    jmp SPIN

OP_STORE_H:
    jmp SPIN

OP_STORE_W:
    mov eax, REG(esi)
    add eax, REG(edi)
    mov ecx, REG(ebp)
    bswap ecx
    mov PTR(eax),ecx
    jmp SPIN

OP_MUL:
    mov eax, REG(esi)
    mul DWORD REG(edi)
    mov REG(ebp), eax
    jmp SPIN

OP_ADD:
    mov eax, REG(esi)
    add eax,DWORD REG(edi)
    mov REG(ebp), eax
    jmp SPIN

OP_DIV:
    mov eax, REG(esi)
    xor edx, edx
    div DWORD REG(edi)
    mov REG(ebp), eax
    jmp SPIN

OP_NOR:
    mov eax, REG(esi)
    or  eax,DWORD REG(edi)
    not eax
    mov REG(ebp), eax
    jmp SPIN

OP_MOVI:
    mov eax, edx
    mov ecx, edx
    shr eax, 5
    and eax, 0xffff
    and ecx, 37o
    shl eax, cl
    mov REG(ebp), eax
    jmp SPIN

OP_CMOV:
    mov eax, REG(edi)
    test eax, eax
    jz .F
    mov eax, REG(esi)
    mov REG(ebp), eax
.F:
    jmp SPIN

OP_OUT:
    mov eax, REG(ebp)		; eax=REGS[ebp]
    mov [outchar], al		; outchar=al
    mov edx,1			; message length=1
    mov ecx,outchar		; ecx=outchar
    mov ebx,1			; stdout
    mov eax,4			; sys_write
    int 0x80			; call kernel
    jmp SPIN

OP_IN:
    mov ebx,0			; stdin
    mov edx,1			; 1 character
    mov ecx,inchar
    mov eax,3			; sys_read
    int 0x80			; call kernel
    test eax,eax
    jz eof
    mov eax,0			; eax=0
    mov al,[inchar]		; al=inchar
    mov REG(ebp),eax		; REGS[ebp]=eax
    mov edx,1
    mov ecx,inchar
    mov ebx,1
    mov eax,4
    int 0x80			; echo to stdout
    jmp SPIN

OP_READ:
    mov ecx, 0x200
    mov esi, REG(esi)
    shl esi, 9
    lea esi, [DISK + esi]
    mov edi, REG(ebp)
    lea edi, PTR(edi)
    cld
    rep movsb
    jmp SPIN

OP_WRITE:
    mov ecx, 0x200
    mov esi, REG(esi)
    shl esi, 9
    lea esi, [DISK + esi]
    mov edi, REG(ebp)
    lea edi, PTR(edi)
    xchg esi,edi
    cld
    rep movsb
    jmp SPIN

OP_HALT:
     jmp start
eof:
;
;   Write out DISK area to diskout.img:
;
    mov ebx,outfile
    mov ecx,1101o               ; O_WRONLY|O_CREAT|O_TRUNC
    mov edx,664o                ; mode
    mov eax,5                   ; sys_open
    int 0x80
    mov [fd],eax                ; fd=open("diskout.img",O_WRONLY|O_CREAT|O_TRUNC,0664);
    mov ebx,[fd]
    mov ecx,DISK
    mov edx,100000              ; write(fh,DISK,100000);
    mov eax,4
    int 0x80
    mov eax,1			; sys_exit
    int 0x80
    

section	.data

fd	dd	0		; file descriptor
outchar	db	0		; character to write
inchar	db	0		; character read in
infile  db	'disk.img',0	; input file name
outfile db	'diskout.img',0	; output file name

section .bss
 
REGS resb 64 * 4
MEM resb 4*1024*1024
DISK resb 100000


